
/*--------------------------------------------------------------------------*\
 *                                                                          *
 *           This Module contains Proprietary Information of JCM            *
 *                 and should be treated as Confidential.                   *
 *                                                                          *
\*--------------------------------------------------------------------------*/

#define VAR

#include "bbt.h"

/*--------------------------------------------------------------------------*/

#ifdef QNX
main( argc, argv )
int argc;
char *argv[];
#endif

#ifdef UNIX
#include <errno.h>
main( argc, argv )
int argc;
char **argv;
#endif
{
    FILE *fi;

#ifdef UNIX
    int c;
    extern char *optarg;
    extern int optind;
#endif


    /*-------------------------------------------------------------*/

    idxname [0]     =   '\0';
    prefix  [0]     =   '\0';
    modem   [0]     =   '\0';

    file_name[0]        =   '\0';
    file_size       =   0L;
    file_date       =   0L;
    file_perm       =   0;

    qterm           =   0;
    sbbt            =   0;
    receive_serv        =   0;
    packet_size     =   DEF_PACKET_SIZE;
    fast            =   0;
    bbt_index       =   0;
    upload          =   0;
    debug           =   0;
    verbose         =   0;
    text            =   0;
    look            =   0;
    options         =   0;
    state           =   1;
    slide           =   1;
    version         =   0;
    compress        =   0;
    bits8           =   0;
    fversion        =   -1;
    setline         =   1;

    /* Version de BBT on l'on ne peu que faire de l'envoi */
    if ( strcmp( "sbbt", last(argv[0]) )==0 ) sbbt=1;


#ifdef DEMO_DATE
	{
	long clock;

	time( &clock );
	if ( clock > ( 0x17512ac4L + (15L*3600L*24L)) )
		abort("Demo date expired\n");
	}
#endif

    /*-------------------------------------------------------------*/

#ifdef UNIX

    fast = 1;   /* version Unix pas de speed transpac x25 */

    if (argc<2)
        usage ();

#ifdef COHERENT
    strcpy( modem, ttyname (fileno (stdin)));
#else
    if ( sbbt )
       strcpy( modem, "/dev/tty" ); /* Normalement pour tout les Unix */
    else
    if ( access( "/dev/tty1a",0 ) != -1 )
        strcpy( modem, "/dev/tty1a" );  /* Xenix - Unix SCO */
    else
        strcpy( modem, "/dev/tty00" );  /* ESIX System V R3.2 */
#endif
    while ( (c=getopt(argc,argv,"gidvcs:f:l:a:r:p:u:x:")) != -1 )
    {

    switch( c )
        {
        case 's':
        case 'f':
                    state=2;
                    strcpy( file_name, optarg );
                    break;
        case 'x':
                    state=2;
                    bbt_index=1;
                    strcpy( idxname, optarg);
                    break;
        case 'g':   if ( !sbbt ) receive_serv=1;         break;
        case 'l':   if ( !sbbt ) strcpy( modem, optarg );     break;
        case 'a':   packet_size = atoi(optarg);
                    if ( packet_size > DEF_PACKET_SIZE )
                        abort("Packet Size <= 3072\n");
                    break;
        case 'r':   fversion = atoi( optarg );  break;
        case 'p':   strcpy( prefix, optarg );   break;
        case 'i':   slide=0;                    break;
        case 'd':   debug=1;                    break;
        case 'v':   verbose=1;                  break;
        case 'u':
                    if ( !sbbt ) upload=1;
                    state=2;
                    strcpy( file_name, optarg );    break; 
        case 'c':   setline=0;                  break;
        case '?':   usage ();
        }
    }

    if ( sbbt && state != 2 )
       {
       fprintf( stderr, "This release of BBT can **ONLY** send file\nplease type 'sbbt' RETURN for help\n" );
       exit(0);
       }

    if ( !sbbt )
        {
        lect = fopen( modem, "r+" );
        ecri = fopen( modem, "w+" );
        }
    else
        {
        lect = stdin;
        ecri = stdout;
        }

    if ( lect==NULL || ecri==NULL )
        {
        if (lect == NULL)
            printf("Unable to open device %s for input.\n", modem);
        if (ecri == NULL)
            printf("Unable to open device %s for output.\n", modem);
        perror ("open");
        fflush( stdout );
        exit(-1);
        }
#endif      

#ifdef QNX

    if (argc<2)
    {
    printf( "%s(%s)\n\n%s%s%s%s%s%s%s%s%s%s%s%s%s",
        "BBT version 2.2U PROTOCOLE [jcm]\n",__DATE__,
        "  Protocole concu par Jean-Claude MICHOT.\n",
        "  Toute utilisation commerciale est interdite sans\n",
        "  l'accord ecrit de l'auteur.\n\n",
        "use:     bbt [options]*\n",
        "options: +receive_serv +verbose +debug m=modem u=upload -slide +8bits\n",
        "         f=send_file_name x=send_index p=prefix +text +look +fast\n",
        "         s=packet_size(default:s=3072+s/4) v=nu_version(0,1,2,3,4,5,6)\n\n",
        "  Exemples d'utilisations au niveau utilisateur\n",
        "  ---------------------------------------------\n",
        "- (Download) Recevoir un fichier d'un serveur :\n",
        "  'bbt m=$modem (+verbose)'\n",
        "- (Upload)   Envoyer un fichier a un serveur  :\n",
        "  'bbt m=$modem u=file_to_upload (+verbose) (s=size)'\n\n"
        );
    exit(0);
    }

    if ( !detach( 1 ) )
        error( "Timer task must be present.\n" );

    zero( &file_name, 79 );
    sprintf( modem, "[%d]$tty%d", My_tty_nid, My_tty );

	set_priority( 9 );

    while(argc > 1)
    {
    char *p;
    p = argv[--argc];
    switch((*p << 8) | *(p + 1))
        {
        case 'RE':
        case 're':
        case '+R':
        case '+r':      receive_serv=1;             break;
        case '+D':
        case '+d':      debug=1;                    break;
        case '+V':
        case '+v':      verbose=1;                  break;
        case 'M=':
        case 'm=':      strcpy( modem, p+2 );       break;
        case '-8':
        case '+8':      bits8=1;                     break;
        case 'S=':
        case 's=':      packet_size = atoi(p+2);
                        if ( packet_size > DEF_PACKET_SIZE )
                            abort("Packet size <= 3072\n");
                                                    break;
        case '+T':
        case '+t':      text=1;                     break;

        case 'V=':
        case 'v=':      fversion=atoi( p+2 );       break;

        case '+F':
        case '+f':      fast=1;                     break;

        case '-S':
        case '-s':      slide=0;                    break;

        case '+L':
        case '+l':      look=1;                     break;

        case 'X=':
        case 'x=':      state=2;
                        bbt_index=1;
                        strcpy( idxname, p+2 );     break;

        case 'SE':
        case 'se':      state=2;                    break;

        case 'F=':
        case 'f=':      state=2;
                        strcpy( file_name, p+2 );   break;

        case 'U=':
        case 'u=':      state=2;
                        upload=1;
                        strcpy( file_name, p+2 );   break;

        case 'P=':
        case 'p=':      strcpy( prefix, p+2 );      break;

        default :       
                    if ( *p == '$' )    /* Special pour Qterm */
                        {
                        strcpy( modem, p );
                        receive_serv = 0;
                        verbose = 1;
                        qterm = 1;
                        }
                    else
                    if ( state == 2 )
                        {
                        strcpy( file_name, p );
                        break;
                        }
                    else
                        {
                        printf("BBT: Invalid parameter '%s'\r\l", p );
                        exit(-1);
                        }
        }
    }

    /* Si le TTY < 19 alors c'est du RTC donc pas de tempo *
     * comme sur transpac car la il n'y a pas de PAVI pour *
     * bufferise !                                         */

    if ( My_tty < 19 ) fast=1;

    lect = fopen( modem, "r" );
    ecri = fopen( modem, "w" );

    if ( lect==NULL || ecri==NULL )
        {
        printf("Unable to open device %s.\r\l", modem);
        fflush( stdout );
        exit(-1);
        }
#endif

    options = get_option( lect );
    set_option( lect, HFLOW );

    switch( state )
    {
    case 1:
            /*----------------------*/
            /* RECEPTION DE FICHIER */
            /*----------------------*/

            if ( !receive_serv )
                {
                printf("\nBBT Scanning...\n");
                fflush( stdout );
                }

            while ( 1 )
            {
            scanning();

            if ( !receive_serv )
                {
                printf("BBT Receiving : ");
                fflush( stdout );
                }

            receive_file();
#ifndef COHERENT
            if ( qterm )
                {
                set_option( lect, options );
                exit(0);
                }
#else
            set_option( lect, options );
            exit(0);
#endif
            }

            break;

    case 2 :
            /*------------------*/
            /* ENVOI DE FICHIER */
            /*------------------*/

            if ( bbt_index )
            {
            long pos=0L;
            int stop;
            extern long ftell();

            stop=0;
            do  {
                fi = fopen( idxname, "r" );
                if ( !fi )
                    {
                    set_option( lect, options );
                    abort("Unable to open Index File\n");
                    }
                fseek( fi, pos, 0 );
                if ( fgets( file_name, 80, fi ) != NULL )
                    {
                    pos = ftell( fi );
                    fclose( fi );

                    file_name[ strlen(file_name)-1 ] = 0;
                    if ( verbose && !upload )
                        printf("\nBBT Sending File (index) : ");
                    if ( verbose && upload  )
                        printf("\nBBT Upload File (index) : ");
                    fflush( stdout );

                    send_file();
                    if ( verbose ) printf("\n\n");
                    }
                else
                    {
                    fclose( fi );
                    stop=1;
                    }
                }
            while( !stop );
            }

            else

            {
            if ( verbose && !upload ) printf("\nBBT Sending File : ");
            if ( verbose && upload ) printf("\nBBT Upload File : ");
            fflush( stdout );
            send_file();
            if ( verbose ) printf("\n\n");
            }

            set_option( lect, options );
            exit( 0 );

            break;
    }

    set_option( lect, options );
}

/*-----------------------------------------------------------------*/
#ifdef UNIX
usage ()
{
#ifdef COHERENT
    printf( "BBT version 2.2 for COHERENT system, %s.\n\n%s%s%s%s", __DATE__,
#else
    printf( "BBT version 2.2U du (10-Fevrier-92).\n" );
    printf( "\n%s%s%s%s",
#endif
        "  Protocole concu par Jean-Claude MICHOT.\n",
        "  Toute utilisation commerciale est interdite\n",
        "  sans l'accord ecrit de l'auteur.\n\n", 
        "usage:    bbt [options]*\n"
        );

    if ( !sbbt )
    printf( "%s%s%s%s%s",
        "options:  [-p prefix] [-s|f send_file]\n",
        "          [-u upload_file] [-x index_file]\n",
        "          [-l line] [-a packet_size] [-r release]\n",
        "          [-c don't_set_line] [-g receive_serv]\n",
        "          [-d debug] [-i slide] [-v erbose]\n"
        );          
    else
    printf( "%s%s%s%s",
        "options:  [-p prefix] [-s|f send_file]\n",
        "          [-x index_file] [-c don't_set_line]\n",
        "          [-a packet_size] [-r release]\n",
        "          [-d debug] [-i slide] [-v erbose]\n"
        );          
    exit(0);
}
#endif

/*-----------------------------------------------------------------*/

scanning()              /* Attend de recevoir la chaine "@@!@@" pour */
{                       /* executer la fonction receive_file() */
    int len,c,p;

    p=0;
    while (1)
    {
    state=len=0;

#ifndef COHERENT
    while ( (c=getc(lect)) != 0x0d && c != 0x0a && c!=EOF )
#else
    while (read (fileno (lect), &c, 1) && (c &= 0x7f) != 0x0d && c != 0x0a )
#endif
        {
        rb[len]=c;
        if (len==129) len=0;
        len++;
        }

    rb[len]='\0';
    if (    strcmp( rb, SS_TRANS )==0 ) return;
    if (    strncmp( rb, SS_STOP, strlen(SS_STOP)  )==0 ||
            ( receive_serv && ++p > 4 ) )
        {
        set_option( lect, options );
        exit(0);
        }

    }
}

get_paquet(timeout)
int timeout;
{
	char c;
	int i;

    zero( &rb[0], 8192 );           /* Efface le tableau r[] */

    if ( timeout )
        {
#ifdef QNX
#ifdef V210
        lect->_flags |= _SLIMY;             /* Enable timed fget    */
        lect->_arg[0] = timeout*20;         /* Set desired timeout  */
#else
        set_timer( TIMER_FORCE_READY, RELATIVE, timeout*20 );
#endif
#endif
        }

#if 0
    fgetline( lect, rb, 8192 ); /* Saisie rb[] valide par 0x0d */
#else
	i=0;
    while ( (c=getc(lect)) != 0x0d && c != 0x0a && i < 8192 )
		rb[i++] = c;
	rb[i++]=0x0d;
	rb[i]='\0';
#endif

    if ( strncmp( rb, SS_STOP, strlen(SS_STOP)  )==0 )
        {
        set_option( lect, options );
        exit(0);
        }

    if ( timeout )
        {
#ifdef QNX
#ifdef V210
        lect->_flags &= ~_SLIMY;    /* End timed fget   */
#else
        set_timer( TIMER_CANCEL, RELATIVE );
#endif
#endif
        }

    if ( rb[0] )                    /* Attention si len(rb)=0 rb[-1] Grr */
        rb[ strlen(rb)-1 ] = 0;     /* Elimine le 0x0d de fin de tableau */

    read_mdm( rb );           /* Tace... Debug */
}

#ifdef QNX
verbose_get_paquet(val)
long val;
{   int n,i;

    n=i=0;
    zero( &rb[0], 8192 );           /* Efface le tableau r[] */

    while ( 1 )
    {
    n = char_waiting(lect);
    if ( n )
        {
        while ( n-- )
            {
            rb[ i ] = getc( lect );
            if ( rb[i] == 0x0a || rb[i] == 0x0d )
                {
                read_mdm( rb );           /* Tace... Debug */
                rb[ strlen(rb)-1 ] = 0;
                return;
                }
            i++;
            if ( i%128 == 0 )
                printf("[%09ld]\b\b\b\b\b\b\b\b\b\b\b",
                        version==0 ? val+ ((i/4)*3) :
                        version==1 ? val+ ((i/4)*3) :
                        version==2 ? val+ ((i/5)*4) : val+ ((i/5)*4) 
                        );
            }
        }
    set_timer( 0,1,5 );
    }

}
#endif

#ifdef UNIX
#ifndef COHERENT
fgetline( pfd, buf, size )
FILE *pfd;
char *buf;
int size;
{
    int i=0;
    char c;

    while ( (c=getc(pfd)) != 0x0d && c != 0x0a )
    {
    buf [i] = c & 0x7f;
    i++;
    if ( i>size ) return(i);
    }
    if ( c!=EOF ) buf[i]=c;
    buf[++i] = 0;
    return(i);
}
#endif
#endif

#ifdef COHERENT
fgetline( pfd, buf, size )
FILE *pfd;
char *buf;
int size;
{
    int i=0;
    char c;

    while (read (fileno (pfd), &c, 1) && (c &= 0x7f) != 0x0d && c != 0x0a )
    {
    buf [i] = c;
    i++;
    if ( i>size ) return(i);
    }
    if ( c!=EOF ) buf[i]=c;
    buf[++i] = 0;
    return(i);
}
#endif
