
/*--------------------------------------------------------------------*
 *
 *    BBT Protocole de Transfert de fichier sur le serveur QBBS.
 *
 * BBT, Version 2.1 :
 *
 * Protocole cree par Jean-Claude MICHOT en Juin 89 pour le transfert
 * de fichiers avec le serveur QBBS. Serveur ASCII 80 Col accessible
 * par les PAVI (Point d'Acces VIdeotex) Donc 7 Bits.
 *
 *
 * TOUTE UTILISATION COMMERCIALE EST STRICTEMENT INTERDITE SANS L'ACCORD
 *                          ECRIT DE L'AUTEUR !
 *
 *--------------------------------------------------------------------*/

#include <stdio.h>   

/* #define QNX */           /* Qnx 2.1x          (Jean-Claude MICHOT) */
/* #define UNIX */          /* Unix System V     (Jean-Claude MICHOT) */
/* #define COHERENT */      /* Coherent, ou BSD  (Jean-Pierre PARISY) */
/* #define PQNX */          /* PosixQnx 4.0      (Jean-Claude MICHOT) */

#ifdef QNX
    #include <io.h>
    #include <math.h>
    #include <dev.h>
    #include <magic.h>
    #include <tiny.h>
    #include <lfsys.h>
    #include <timer.h>
#endif

#define zero(a,b)       memset(a,'\0',b)

#define SS_TRANS        "@@!@@"
#define SS_STOP         "#BREAK#"

#define DEF_PACKET_SIZE 3072

#define VERSION         6

/*---------------------------------------------------------*/

#ifndef VAR
#define VAR extern
#endif

/*---------------------------------------------------------*/

VAR FILE *lect,*ecri;
VAR char rb         [ 16384 ];
VAR char de         [ 16384 ];
VAR char idxname    [ 80 ];
VAR char prefix     [ 80 ];
VAR char modem      [ 10 ];
VAR char trash      [ 80 ];

VAR char file_name  [ 80 ];     /* Nom du fichier */
VAR long file_size;             /* Taille du fichier */
VAR long file_date;             /* Date du fichier */
VAR int  file_perm;             /* Perms du fichier */

VAR int nump;                   /* Numero de paquet */
VAR int version;                /* Version de BBT */
VAR int fversion;               /* Force une version */

VAR int setline;                /* Set line IO / 7e1 1200? */
VAR int receive_serv;
VAR int packet_size;
VAR int fast;
VAR int slide;
VAR int bbt_index;
VAR int upload;
VAR int debug;
VAR int verbose;
VAR int text;
VAR int state;
VAR int qterm;
VAR int look;
VAR int compress;
VAR int bits8;
VAR long cps;
VAR int options;
VAR int sbbt;			/* BBT only for SEND file */

extern int atoi();
extern unsigned int atoh();
extern long ftell();
extern long atol();

/*---------------------------------------------------------*/
