

#include <stdio.h>   
#include <sys/fcntl.h>
#include <time.h>

#include <signal.h>
#include <sgtty.h>
#include <sys/types.h>
#include <sys/stat.h>


struct sgttyb	rawmode,
		cookedmode,
		*io;
struct tchars	rawchars,
		cookedchars;
extern int setline;
extern int options;

int get_option( FP )
FILE *FP;
{
	if (!options) {
		gtty( fileno (FP), &cookedmode);
		ioctl (fileno (FP), TIOCGETC, &cookedchars);
	}
	return 1;
}

set_option( FP, restore )
FILE *FP;
int restore;
{
	int fdes;

	if ( !setline || !options) return;

	if (restore) {
		stty (fileno (FP), &cookedmode);
		ioctl (fileno (FP), TIOCSETC, &cookedchars);
		return;
	}

	fdes = fileno( FP );
	io = &rawmode;

	gtty( fdes, io);
	ioctl (fdes, TIOCGETC, &rawchars);
	io->sg_flags |= (RAW);
	io->sg_flags &= ~(ECHO | CRMOD);
	rawchars.t_brkc = '\r';
	if (stty (fdes, io) < 0 || ioctl (fdes, TIOCSETC, &rawchars) < 0)
		{
		stty (fileno (FP), &cookedmode);
		ioctl (fileno (FP), TIOCSETC, &cookedchars);
		printf("Configuration du TTY impossible\n");
		exit(-1);
		}
}
