
/*--------------------------------------------------------------------------*\
 *                                                                          *
 *           This Module contains Proprietary Information of JCM            *
 *                 and should be treated as Confidential.                   *
 *                                                                          *
\*--------------------------------------------------------------------------*/

#ifdef UNIX
#include <ctype.h>
#include <sys/types.h>
#include <sys/stat.h>
#endif

#include "bbt.h"

/*-----------------------------------------------------------------------*/

char *last(arg)
char *arg;
{   register int r;

    r=strlen(arg);
    while (r>=0)
    {
    switch( arg[r] )
        {
        case '/':   case '^':   case '>':
        case '<':   case '|':   case ';':
            return( &arg[r+1] );
        }
    r--;
    }
    return(&arg[0]);
}

filtre_file_name( fi )
char *fi;
{   char tmp[80];
    int i;

    strcpy( fi, last(fi) );

    for( i=0; i<strlen(fi); i++ )
		{
		fi[i] = tolower( fi[i] );
		if ( !isalnum(fi[i]) && fi[i] != ' '
			 && fi[i] != '.' && fi[i] != '-' ) fi[i]='x';
		}

    if ( prefix[0] )
        {
        sprintf( tmp, "%s%s", prefix, fi );
        strcpy( fi, tmp );
        }
}


/*-----------------------------------------------------------------------*/
/*-----------------------------------------------------------------------*/

#ifdef QNX

lchmod( namefile, mode )
char *namefile;
unsigned int mode;
{   FILE *fp;
    struct dir_entry dir_entry;
    register int i,v[5];
    
    v[0] = mode / 100;
    v[1] = (mode - (v[0]*100)) / 10;
    v[2] =  mode - (v[0]*100) - (v[1]*10);

    for (i=0; i<3; i++)
        switch( v[i] )
            {
            case 0 :    v[i] = 0;       break;  /* - */
            case 1 :    v[i] = 8;       break;  /* x */
            case 2 :    v[i] = 2+4;     break;  /* wa */
            case 3 :    v[i] = 8+4+2;   break;  /* wax */
            case 4 :    v[i] = 1;       break;  /* r */
            case 5 :    v[i] = 8+1;     break;  /* rx */
            case 6 :    v[i] = 1+4+2;   break;  /* rwa */
            case 7 :    v[i] = 8+4+2+1; break;  /* rwax */
            }

    if ( ( fp = fopen( namefile, "m") )==NULL ) return(-1);
    if(0 != get_dir_entry(fp, &dir_entry))  { fclose(fp); return(-1); }
    if ( dir_entry.fattr & _DIRECTORY )     { fclose(fp); return(-1); }
    dir_entry.fattr     = (dir_entry.fattr   & 0xf0) | v[0];
    dir_entry.fgperms   = (dir_entry.fgperms & 0xf0) | v[1];
    dir_entry.fperms    = (dir_entry.fperms  & 0xf0) | v[2];
    if(0 != set_dir_entry(fp, &dir_entry))  { fclose(fp); return(-1); }
    fclose(fp);
    return(0);
}

chdate( namefile, date )
char *namefile;
long date;
{   FILE *fp;
    struct dir_entry dir_entry;
    register int i,v[5];
    
    if ( ( fp = fopen( namefile, "m") )==NULL ) return(-1);
    if(0 != get_dir_entry(fp, &dir_entry))  { fclose(fp); return(-1); }
    dir_entry.fseconds = date;
    if(0 != set_dir_entry(fp, &dir_entry))  { fclose(fp); return(-1); }
    fclose(fp);
    return(0);
}

#define UNIX_READ   4
#define UNIX_WRITE  2
#define UNIX_EXEC   1

filemode( namefile )
char *namefile;
{   FILE *fp;
    static struct dir_entry dir_entry;
    register unsigned i,v[4],r[4];

    if ( ( fp = fopen( namefile, "m") )==NULL ) return(-1);
    if(0 != get_dir_entry(fp, &dir_entry))  { fclose(fp); return(-1); }
    fclose( fp );

    v[0] = dir_entry.fattr   & 0x0f ;
    v[1] = dir_entry.fgperms & 0x0f ;
    v[2] = dir_entry.fperms  & 0x0f ;

    for (i=0; i<3; i++)
        {
        r[i]=0;
        if ( v[i] & _READ   ) r[i] |= UNIX_READ;
        if ( v[i] & _WRITE  ) r[i] |= UNIX_WRITE;
        if ( v[i] & _APPEND ) r[i] |= UNIX_WRITE;
        if ( v[i] & _EXECUTE) r[i] |= UNIX_EXEC;
        }

    i = r[0] * 100 + r[1] * 10 + r[2] ;

    return( i );
}

/*-----------------------------------------------------------------------*/
/*-----------------------------------------------------------------------*/

/* -------------------- SPECIAL QBBS -------------------- */

#ifdef QBBS

qbbs_upload( userid, file, size )
char *userid,*file;
long size;
{
    int tid;
    FILE *fp;

    tid = name_locate( "kerbbs", My_nid, 20 );
    if ( tid )
        {
        char msg[80];
        sprintf( msg, "2%s %ld", userid, size );
        send( tid, &msg, &msg, strlen(msg) );
        }

    fp = fopen( "/qbbs/files/UPLOAD", "a" );
    if ( !fp ) return;
    fprintf( fp, "%-15.15s %-8ld %-8.8s %s\n",
                userid, size,
                version == 0 ? "BBT Sum"  :
                version == 1 ? "BBT Crc"  :
                version == 2 ? "BBT Crc+" : "BBT Crc+",
                file );
    fclose( fp );

}

qbbs_download( userid, file, size )
char *userid,*file;
long size;
{
    int tid;
    FILE *fp;
    char fpat[81];

    getcwd( fpat, 80 );

    tid = name_locate( "kerbbs", My_nid, 20 );
    if ( tid )
        {
        char msg[80];
        sprintf( msg, "1%s %ld", userid, size );
        send( tid, &msg, &msg, strlen(msg) );
        }

    fp = fopen( "/qbbs/files/DOWNLOAD", "a" );
    if ( !fp ) return;
    fprintf( fp, "%-15.15s %-8ld %-8.8s %s/%s\n",
                userid, size,
                version == 0 ? "BBT Sum"  :
                version == 1 ? "BBT Crc"  :
                version == 2 ? "BBT Crc+" : "BBT Crc+",
                fpat, file );
    fclose( fp );
}

#endif

#endif

/*-----------------------------------------------------------------------*/
/*-----------------------------------------------------------------------*/


#ifdef UNIX

chdate( filename, date )
char *filename;
long date;
{
    time_t times[2];

    times[0] = date;
    times[1] = date;
    utime (filename, times);
}

lchmod( filename, mode )
char *filename;
int mode;
{
    char perms[8];
    int omode;

    sprintf (perms, "%d", mode);
    sscanf (perms, "%o", &omode);
    chmod (filename, omode);
}

filemode( filename )
char *filename;
{
    struct stat strstat;

    stat (filename, &strstat);
    return( strstat.st_mode );
}

unsigned int atoh(a)
char *a;
{
    unsigned int r,i;
    char x;

    for(i=0,r=0; i<strlen(a); i++)
    {
    x = toupper (a[i]);
    switch( x )
        {
        case '0':   case '1':   case '2':   case '3':
        case '4':   case '5':   case '6':   case '7':
        case '8':   case '9':
                    r = (r * 16) + (x - '0');
                    break;
        case 'A':   case 'B':   case 'C':   case 'D':
        case 'E':   case 'F':
                    r = ((r * 16) + ( x - 'A' ) + 10);
                    break;
        default :   break;
        }
    }
   return(r);
}

#endif


void ret_deb()
{
      sprintf( trash, "%c%c",0x13,0x4c);
      write_mdm( trash );
}

void ret_fin()
{
      sprintf( trash, "%c%c",0x13,0x4d);
      write_mdm( trash );
}

void mec_on()
{
#ifndef TEST
      sprintf( trash, "%c%c%c%c%c%c%c%c%c%c",0x1b,0x3b,0x61,0x5b,0x51,0x1b,0x3b,0x61,0x58,0x52);
      write_mdm( trash );
#endif
}

void mec_off()
{
#ifndef TEST
      sprintf( trash, "%c%c%c%c%c%c%c%c%c%c",0x1b,0x3b,0x60,0x5b,0x51,0x1b,0x3b,0x60,0x58,0x52);
      write_mdm( trash );
#endif
}

