
#include "bbt.h"

/*-----------------------------------------------------------------*/
/*------------------------R E C E I V E----------------------------*/
/*-----------------------------------------------------------------*/

receive_file()
{
    FILE *fp;
    long dt;            /* Reprise de telechargemenet a partir de */
    int l;              /* longeur du paquet decode */
    int add;            /* Reprise de telechargement */
    int bad_crc;        /* Nombre de BAD CRC */
	unsigned lcrc;
    long first_clock;   /* debut de transfert */
    long start_clock;   /* debut de transfert du dernier bloc */
    long last_clock;    /* fin de transfert */

    extern long ftell();

    l = bad_crc = add = 0;
    dt = first_clock = last_clock = 0L;
    nump = 1;

    file_perm = 0;
    file_date = file_size = 0L;

    get_paquet(0);
    sscanf( rb, "%ld %s %lx %d %d %d %d",
        &file_size, &file_name[0], &file_date, &file_perm,
		&version, &compress, &bits8 );

	/* un truc qui traine depuis des lustres... */
    if ( file_perm == 438 ) file_perm=666;  /* (octal)0666 = (deci)438 */

	if (	strcmp( file_name, "uinfo" )==0 || 
			strcmp( file_name, "ustat" )==0 || 
			strcmp( file_name, "bal.msg" )==0 || 
			strcmp( file_name, "bal.idx" )==0
		)
		strcat( file_name, "x" );

    filtre_file_name( file_name );

    if ( !receive_serv )
        {
        printf("%-14.14s (%8ld) F(%-4.4s)%c ",
                file_name, file_size,
                version==0 ? "Sum"  :
                version==1 ? "Crc"  :
                version==2 ? "Crc+" :
				version==3 ? "CrcC" :
				version==4 ? "CrcS" :
				version==5 ? "8Crc" :
				version==6 ? "8Sec" : "????",
                compress   ?  'C'   : ' ' );
        fflush( stdout );

        time ( &first_clock );
        time ( &start_clock );
        }


    dt = 0L;

    if ( access( file_name, 0 ) == -1 ) /* le fichier n'existe pas */
        {
        add=0;
#ifdef QNX
        if ( ! (fp=fopen(file_name,"wf")) )
#else
        if ( ! (fp=fopen(file_name,"w")) )
#endif
            {
            write_mdm( "?\r" ); /* Demande L'arret de l'envoi */
            printf( "Unable to receive This file\n");
            return;
            }
        }
    else                                    /* le fichier existe deja */
        {
        add=1;
#ifdef QNX
        if ( ! (fp=fopen(file_name,"af")) )
#else
        if ( ! (fp=fopen(file_name,"a")) )
#endif
            {
            write_mdm( "?\r" ); /* Demande L'arret de l'envoi */
            printf( "Unable to update This file\n");
            return;
            }
        dt = ftell(fp);
        }
#ifndef COHERENT
    if ( file_perm ) lchmod ( file_name, file_perm );
    if ( file_date ) chdate ( file_name, file_date );
#endif

    /* Renvoi la reponse au 1er paquet !

       "!" + Numero_de_version + " " 
           + Taille_deja_recu_si_reprise + " "
           + Taille maxi d'un packet (en reception) + " "
           + CRC-16
    */

	sprintf(trash, "!%02d %ld %d ",	VERSION, dt, DEF_PACKET_SIZE );
	lcrc = checksum( trash, strlen(trash) );
	sprintf( trash+strlen(trash), "%04x\r", lcrc );
	write_mdm(trash);

	/* Ok Nom, Version, Taille bien recu ! */

    while (1)
    {
#ifdef QNX
    if ( verbose && !receive_serv )
        {
        verbose_get_paquet( ftell(fp) );
        }
    else
#endif
        get_paquet(0);

	/* Demande de re-synchronisation */
	if ( rb[0] == '+' )
		{
		long            pos, rs;
		unsigned		ccrc,vr;

		sscanf( rb+1, "%ld %x", &rs, &lcrc );
		ccrc = lcrc;
		if ( version > 5 )
			{
			rb[ strlen(rb)-4 ] = '\0';
			ccrc = checksum( rb, strlen(rb) );
			}

        pos = ftell(fp);

		if ( !receive_serv )
			{
    	    sprintf( trash, "[%09ld] SYNC %09ld ", pos, rs  );
    	    printf( "%s", trash );
    	    for(vr=strlen(trash); vr>0; vr--) printf("\b");
			}

		if ( lcrc != ccrc )
			{
			write_mdm("/H\r");	/* Re-Synchro STP, crc err */
			}
		else
			{
			/* re-sync dans la position du fichier */
			fseek( fp, (long) rs, 0L );
			write_mdm("!H\r");	/* C'est OK on continue */
			}
		continue;
		}


    /* Fin de Transfert ? */
    if ( strncmp( rb, SS_TRANS, strlen(SS_TRANS) ) == 0 || bad_crc > 8 )
        {
        fclose( fp );
#ifdef COHERENT
        if ( file_perm ) lchmod ( file_name, file_perm );
        if ( file_date ) chdate ( file_name, file_date );
#endif
        if ( !bad_crc )
            write_mdm( "#\r");
        else
            {
            write_mdm( SS_STOP );
            write_mdm( "\r" );
            }
        set_option( lect, options );

        if ( !bad_crc && !receive_serv )
            {
            time( &last_clock );
            cps = dt / (last_clock - first_clock);

            printf( " Received %ld CPS %0ld.%2.02ld mn\n",
                    dt / ( last_clock - first_clock ),
                    ( last_clock - first_clock ) / 60,
                    ( last_clock - first_clock ) % 60 );
            }
        if ( bad_crc ) printf("Too many Bad CRC !\n");


#ifdef QBBS
        /* RUSEtine destine a informer QBBS du nombre d'octet Envoye */

        /* -------------------- SPECIAL QBBS -------------------- */
        if ( !bad_crc )
            qbbs_upload( cuserid(NULL), file_name, file_size,
                            version == 0 ? "BBT Sum"  :
                            version == 1 ? "BBT Crc"  :
                            version == 2 ? "BBT Crc+" : "BBT Crc*"
                        );
        /* ------------------------------------------------------ */
#endif
        set_option( lect, options );

        if ( receive_serv ) exit(0);    /* Fin de reception serveur */
        return;
        }

    if ( (l=decode()) )                 /* Decode le paquet ! */
        {
        write_mdm( "!H\r" );             /* C'est OK on continue */

        if ( (dt+l) > file_size ) l = file_size - dt;
        if( l >= 1 ) fwrite( de, l, 1, fp );
        dt += l;

        if ( !receive_serv )        /* DOWNLOAD utilisateur */
            {
            int vr;
            long pos;

            time( &last_clock );
            cps = l / (last_clock - start_clock);
            pos = ftell(fp);
            sprintf( trash, "[%09ld] %02ld%% %3d CPS",
                                pos, 100L*pos/file_size, cps );

            printf( "%s", trash );
            for(vr=strlen(trash); vr>0; vr--) printf("\b");
            time( &start_clock );
            }

        bad_crc=0;
        }
    else
        {
        write_mdm( "?H\r" );             /* Demande sa reemission */

        if ( !receive_serv ) printf( "CRC\b\b\b" );
        bad_crc++;
        }
    }
}
