
/*--------------------------------------------------------------------------*\
 *  History: bbt_unx.c     V1.0, 11-Nov-89  2:36:16pm, jcm,   Baseline      *
 *--------------------------------------------------------------------------*
 *                                                                          *
 *           This Module contains Proprietary Information of JCM            *
 *                 and should be treated as Confidential.                   *
 *                                                                          *
\*--------------------------------------------------------------------------*/

#include <stdio.h>   
#include <fcntl.h>
#include <time.h>

#include <signal.h>
#ifndef PQNX
#include <termio.h>
#else
#include <termios.h>
#define termio termios
#endif
#include <sys/types.h>
#include <sys/stat.h>


struct stat infofic;
struct termio 	setioctl, *io;
struct termio   sauveio;

extern int setline;

/* Peu etre considere comme "sauve_option" (uniquement pour BBT) */

get_option( FP )
FILE *FP;
{
	int fdes;

	if ( !setline ) return;

	fdes = fileno( FP );

#ifdef PQNX
	tcgetattr( fdes, &sauveio );
#else
	if ( ioctl( fdes, TCGETA, &sauveio ) < 0 )
		{
		printf("Configuration du TTY impossible\n");
		exit(-1);
		}
#endif

	return;
}

/* Mise en place du parametrage de BBT pour un minitel ou bien
   restaure le parametrage d'origine si 'restore'==1 */

set_option( FP , restore )
FILE *FP;
unsigned restore;
{
	int fdes;

	if ( !setline ) return;

#ifdef UNIX
	fdes = fileno( FP );

        if ( !restore )
		{
		io = &setioctl;

		io->c_iflag = IGNBRK | IGNPAR | ISTRIP ;
		io->c_oflag = OPOST ;
#ifndef PQNX
		io->c_cflag = B1200 | CS7 | PARENB | CREAD | CLOCAL ;
#else
		io->c_cflag = CS7 | PARENB | CREAD | CLOCAL ;
#endif
		io->c_lflag = ISIG;
#ifndef PQNX
		io->c_line		= (char)0;
#endif
		io->c_cc[VINTR]		= (char)5;
		io->c_cc[VQUIT]		= (char)5;
		io->c_cc[VERASE]	= (char)5;
		io->c_cc[VKILL]		= (char)5;
		io->c_cc[VEOF]		= (char)1;
		io->c_cc[VEOL]		= (char)1;
		}
	else
		{
		io = &sauveio;
		}

#ifdef PQNX
	cfsetispeed( io, B1200 );
	cfsetospeed( io, B1200 );
	tcsetattr( fdes, TCSANOW, io );
#else
	if ( ioctl( fdes, TCSETA, io ) < 0 )
		{
		printf("Configuration du TTY impossible\n");
		exit(-1);
		}
#endif
#endif

}

