
/*--------------------------------------------------------------------------*\
 *  History: edcode.c   V1.5, 11-Nov-89  2:36:16pm, jcm,    Baseline        *
 *--------------------------------------------------------------------------*
 *                                                                          *
 *           This Module contains Proprietary Information of JCM            *
 *                 and should be treated as Confidential.                   *
 *                                                                          *
\*--------------------------------------------------------------------------*/

/* Ce module a ete fourni a :
 *
 * NOM                 Pseudo        Computer      Date       Version
 * -------------------------------------------------------------------
 * Bertand PETIT       elrond        ATARI         17 Nov 89  V1.5
 * Florent PILLET      Tomcat        ATARI         17 Nov 89  V1.5
 * Jean-Noel MOYNE     JNM           AMIGA         17 Nov 89  V1.5
 * Pascal Grange       Ldfa          AMIGA         27 Nov 89  V1.5
 * Rene COUGNENC       rcougnenc     PC            11 Nov 89  V1.5
 * Yannick LE PERF     mikro         PC            27 Nov 89  V1.5
 * Emmanuel DECAEN     TITI61        PC            27 Nov 89  V1.5
 * Michel POLLET       michel        MAC           11 Jan 90  V1.5
 *
 * Jean-Pierre PARISY  Top           PC            17 Mar 90  V1.6
 * Rene COUGNENC       rcougnenc     PC            26 Jun 90  V1.7
 * Vincent POMEY       tricky        ATARI         01 Jui 90  V1.7
 * Jean-Claude RICHARD richard       PC            15 Dec 90  V1.7
 * Herve le DU                       PC-MultiM     Fevrier91  V1.7
 * Hubert DELAHAYE     MemFull       Next          Juillet91  V1.7
 * Marc DI COLO        cistel        PC-Compo      Aout   91  V1.7
 * Ste GOTO-Informat.  goto          PC            22 Nov 91  V1.7
 *
 */

#include "bbt.h"

static char edct[128][5] =
    {
        { 0x20, 0x20, 0x20, 0x20, 0x20 }, { 0x20, 0x20, 0x20, 0x20, 0x40 },
        { 0x20, 0x20, 0x20, 0x20, 0x60 }, { 0x20, 0x20, 0x20, 0x40, 0x20 },
        { 0x20, 0x20, 0x20, 0x40, 0x40 }, { 0x20, 0x20, 0x20, 0x40, 0x60 },
        { 0x20, 0x20, 0x20, 0x60, 0x20 }, { 0x20, 0x20, 0x20, 0x60, 0x40 },
        { 0x20, 0x20, 0x20, 0x60, 0x60 }, { 0x20, 0x20, 0x40, 0x20, 0x20 },
        { 0x20, 0x20, 0x40, 0x20, 0x40 }, { 0x20, 0x20, 0x40, 0x20, 0x60 },
        { 0x20, 0x20, 0x40, 0x40, 0x20 }, { 0x20, 0x20, 0x40, 0x40, 0x40 },
        { 0x20, 0x20, 0x40, 0x40, 0x60 }, { 0x20, 0x20, 0x40, 0x60, 0x20 },
        { 0x20, 0x20, 0x40, 0x60, 0x40 }, { 0x20, 0x20, 0x40, 0x60, 0x60 },
        { 0x20, 0x20, 0x60, 0x20, 0x20 }, { 0x20, 0x20, 0x60, 0x20, 0x40 },
        { 0x20, 0x20, 0x60, 0x20, 0x60 }, { 0x20, 0x20, 0x60, 0x40, 0x20 },
        { 0x20, 0x20, 0x60, 0x40, 0x40 }, { 0x20, 0x20, 0x60, 0x40, 0x60 },
        { 0x20, 0x20, 0x60, 0x60, 0x20 }, { 0x20, 0x20, 0x60, 0x60, 0x40 },
        { 0x20, 0x20, 0x60, 0x60, 0x60 }, { 0x20, 0x40, 0x20, 0x20, 0x20 },
        { 0x20, 0x40, 0x20, 0x20, 0x40 }, { 0x20, 0x40, 0x20, 0x20, 0x60 },
        { 0x20, 0x40, 0x20, 0x40, 0x20 }, { 0x20, 0x40, 0x20, 0x40, 0x40 },
        { 0x20, 0x40, 0x20, 0x40, 0x60 }, { 0x20, 0x40, 0x20, 0x60, 0x20 },
        { 0x20, 0x40, 0x20, 0x60, 0x40 }, { 0x20, 0x40, 0x20, 0x60, 0x60 },
        { 0x20, 0x40, 0x40, 0x20, 0x20 }, { 0x20, 0x40, 0x40, 0x20, 0x40 },
        { 0x20, 0x40, 0x40, 0x20, 0x60 }, { 0x20, 0x40, 0x40, 0x40, 0x20 },
        { 0x20, 0x40, 0x40, 0x40, 0x40 }, { 0x20, 0x40, 0x40, 0x40, 0x60 },
        { 0x20, 0x40, 0x40, 0x60, 0x20 }, { 0x20, 0x40, 0x40, 0x60, 0x40 },
        { 0x20, 0x40, 0x40, 0x60, 0x60 }, { 0x20, 0x40, 0x60, 0x20, 0x20 },
        { 0x20, 0x40, 0x60, 0x20, 0x40 }, { 0x20, 0x40, 0x60, 0x20, 0x60 },
        { 0x20, 0x40, 0x60, 0x40, 0x20 }, { 0x20, 0x40, 0x60, 0x40, 0x40 },
        { 0x20, 0x40, 0x60, 0x40, 0x60 }, { 0x20, 0x40, 0x60, 0x60, 0x20 },
        { 0x20, 0x40, 0x60, 0x60, 0x40 }, { 0x20, 0x40, 0x60, 0x60, 0x60 },
        { 0x20, 0x60, 0x20, 0x20, 0x20 }, { 0x20, 0x60, 0x20, 0x20, 0x40 },
        { 0x20, 0x60, 0x20, 0x20, 0x60 }, { 0x20, 0x60, 0x20, 0x40, 0x20 },
        { 0x20, 0x60, 0x20, 0x40, 0x40 }, { 0x20, 0x60, 0x20, 0x40, 0x60 },
        { 0x20, 0x60, 0x20, 0x60, 0x20 }, { 0x20, 0x60, 0x20, 0x60, 0x40 },
        { 0x20, 0x60, 0x20, 0x60, 0x60 }, { 0x20, 0x60, 0x40, 0x20, 0x20 },
        { 0x20, 0x60, 0x40, 0x20, 0x40 }, { 0x20, 0x60, 0x40, 0x20, 0x60 },
        { 0x20, 0x60, 0x40, 0x40, 0x20 }, { 0x20, 0x60, 0x40, 0x40, 0x40 },
        { 0x20, 0x60, 0x40, 0x40, 0x60 }, { 0x20, 0x60, 0x40, 0x60, 0x20 },
        { 0x20, 0x60, 0x40, 0x60, 0x40 }, { 0x20, 0x60, 0x40, 0x60, 0x60 },
        { 0x20, 0x60, 0x60, 0x20, 0x20 }, { 0x20, 0x60, 0x60, 0x20, 0x40 },
        { 0x20, 0x60, 0x60, 0x20, 0x60 }, { 0x20, 0x60, 0x60, 0x40, 0x20 },
        { 0x20, 0x60, 0x60, 0x40, 0x40 }, { 0x20, 0x60, 0x60, 0x40, 0x60 },
        { 0x20, 0x60, 0x60, 0x60, 0x20 }, { 0x20, 0x60, 0x60, 0x60, 0x40 },
        { 0x20, 0x60, 0x60, 0x60, 0x60 }, { 0x40, 0x20, 0x20, 0x20, 0x20 },
        { 0x40, 0x20, 0x20, 0x20, 0x40 }, { 0x40, 0x20, 0x20, 0x20, 0x60 },
        { 0x40, 0x20, 0x20, 0x40, 0x20 }, { 0x40, 0x20, 0x20, 0x40, 0x40 },
        { 0x40, 0x20, 0x20, 0x40, 0x60 }, { 0x40, 0x20, 0x20, 0x60, 0x20 },
        { 0x40, 0x20, 0x20, 0x60, 0x40 }, { 0x40, 0x20, 0x20, 0x60, 0x60 },
        { 0x40, 0x20, 0x40, 0x20, 0x20 }, { 0x40, 0x20, 0x40, 0x20, 0x40 },
        { 0x40, 0x20, 0x40, 0x20, 0x60 }, { 0x40, 0x20, 0x40, 0x40, 0x20 },
        { 0x40, 0x20, 0x40, 0x40, 0x40 }, { 0x40, 0x20, 0x40, 0x40, 0x60 },
        { 0x40, 0x20, 0x40, 0x60, 0x20 }, { 0x40, 0x20, 0x40, 0x60, 0x40 },
        { 0x40, 0x20, 0x40, 0x60, 0x60 }, { 0x40, 0x20, 0x60, 0x20, 0x20 },
        { 0x40, 0x20, 0x60, 0x20, 0x40 }, { 0x40, 0x20, 0x60, 0x20, 0x60 },
        { 0x40, 0x20, 0x60, 0x40, 0x20 }, { 0x40, 0x20, 0x60, 0x40, 0x40 },
        { 0x40, 0x20, 0x60, 0x40, 0x60 }, { 0x40, 0x20, 0x60, 0x60, 0x20 },
        { 0x40, 0x20, 0x60, 0x60, 0x40 }, { 0x40, 0x20, 0x60, 0x60, 0x60 },
        { 0x40, 0x40, 0x20, 0x20, 0x20 }, { 0x40, 0x40, 0x20, 0x20, 0x40 },
        { 0x40, 0x40, 0x20, 0x20, 0x60 }, { 0x40, 0x40, 0x20, 0x40, 0x20 },
        { 0x40, 0x40, 0x20, 0x40, 0x40 }, { 0x40, 0x40, 0x20, 0x40, 0x60 },
        { 0x40, 0x40, 0x20, 0x60, 0x20 }, { 0x40, 0x40, 0x20, 0x60, 0x40 },
        { 0x40, 0x40, 0x20, 0x60, 0x60 }, { 0x40, 0x40, 0x40, 0x20, 0x20 },
        { 0x40, 0x40, 0x40, 0x20, 0x40 }, { 0x40, 0x40, 0x40, 0x20, 0x60 },
        { 0x40, 0x40, 0x40, 0x40, 0x20 }, { 0x40, 0x40, 0x40, 0x40, 0x40 },
        { 0x40, 0x40, 0x40, 0x40, 0x60 }, { 0x40, 0x40, 0x40, 0x60, 0x20 },
        { 0x40, 0x40, 0x40, 0x60, 0x40 }, { 0x40, 0x40, 0x40, 0x60, 0x60 },
        { 0x40, 0x40, 0x60, 0x20, 0x20 }, { 0x40, 0x40, 0x60, 0x20, 0x40 },
    };

extern unsigned cencode();
extern unsigned cdecode();

/*
#define DEBUG_TIMING 1
static unsigned ttime,ticks1,ticks2;
*/

/*------------------------------------------------------------------*/
/*-Encode (rb[]) en (de[])------------------------------------------*/
/*------------------------------------------------------------------*/

encode( l )
int l;
{
    register int i, j;
    unsigned int crc;
	int org_l = l;

#ifdef DEBUG_TIMING
	ttime = ticks1 = ticks2 = 0;
	ticks1 = get_ticks();
#endif

	if ( version >= 5 )
		{
		l = erep( l, rb, de );
		memset( rb, 0, sizeof(rb) );
        memcpy( rb, de, l );
		}

	if ( bits8 )
		{
		l = ebin8( l, rb, de );
		memset( rb, 0, sizeof(rb) );
        memcpy( rb, de, l );
		}

    memset( de, 0, sizeof(de) );
	if ( version < 5 )
	   sprintf( de, "%04d", org_l );
	else
	   sprintf( de, "%04x", org_l );
    j = 4;
    crc = 0;

	if ( !bits8 )
	{
    if ( version < 2 )
        {
        for( i=0; i<l; i+=3 )
            {
            de[j++] = ' ' + ((rb[i] >> 2) & 0x3f);
            de[j++] = ' ' + (((rb[i] << 4) & 0x30)   | ((rb[i+1] >> 4) & 0xf));
            de[j++] = ' ' + (((rb[i+1] << 2) & 0x3c) | ((rb[i+2] >> 6) & 0x3));
            de[j++] = ' ' + (rb[i+2] & 0x3f);
            }
        }
    else
        {
        char *p,t;

        for ( p=&rb[0]; p < (&rb[0]+l); p+=4 )
            {
            t = p[3] & 0x7F;
            de[j++] = ( ((p[0]&0xF8) >> 3)                  | edct[t][0] );
            de[j++] = ( ((p[0]&0x07) << 2)|((p[1]&0xC0)>>6) | edct[t][1] );
            de[j++] = ( ((p[1]&0x3E) >> 1)                  | edct[t][2] );
            de[j++] = ( ((p[1]&0x01) << 4)|((p[2]&0xF0)>>4) | edct[t][3] );
            de[j++] = ( ((p[2]&0x0F) << 1)|((p[3]&0x80)>>7) | edct[t][4] );
            }
        }
	}
	else
	{
	memcpy( de+j, rb, l );
	}

    crc = checksum( de, strlen( de ) );
#ifndef COHERENT
    sprintf( trash, "%04X", crc );
#else
    sprintf( trash, "%04x", crc );
#endif
    strcat( de, trash );

#ifdef DEBUG_TIMING
	ticks2 = get_ticks();
	ttime = (ticks2 < ticks1) ? (0xFFFF - ticks1) + ticks2 : ticks2 - ticks1;

	fprintf( stderr, "\ncompute encode() %04x %04x %d\n", ticks1,ticks2,ttime );
	fprintf( stderr, "Time: %u.%02u seconds\n", ttime / 20, 5 * (ttime % 20));
#endif

    return (crc);
}

/*------------------------------------------------------------------*/
/*-Decode (rb[]) en (de[])------------------------------------------*/
/*------------------------------------------------------------------*/

decode()
{
    int l,s;    /* retourne la longeur du paquet decode ou 0 si pb CRC */
    int i,j,k;
	int stlrb;
    unsigned int crc,rcrc;

#ifdef DEBUG_TIMING
	ttime = ticks1 = ticks2 = 0;
	ticks1 = get_ticks();
#endif

    memset( &trash[0], 0, 9 );           /* Met a 0 lng[] */

    strncpy( trash, rb, 4 );        /* Copie les 4 1er caract. de rb[] */
	if ( version < 5 )
	    l = s = atoi( trash );          /* Convertion en numerique */
	else
	    l = s = atoh( trash );          /* Convertion en numerique */
    i=0;

	stlrb = strlen(rb)-4;
	if ( stlrb < 0 ) return(0); /* Err de CRC */

    rcrc = atoh    ( rb + stlrb );
    crc  = checksum( rb, stlrb ); /* Crc somme&0xffff */

    if ( crc != rcrc ) return(0);   /* Erreur de CRC */

	if ( !bits8 )
	{
    if ( version < 2 )
        {
        for( k=4; l>0; k+= 4)
            {
            for(j=0;j<4;j++) rb[k+j] -= ' ';
            de[i++] = ((rb[k] << 2) | ((rb[k+1] >> 4) & 0x3));
            if(--l >= 0) de[i++] = ((rb[k+1] << 4) | ((rb[k+2] >> 2) & 0xf));
            if(--l >= 0) de[i++] = ((rb[k+2] << 6) | rb[k+3]);
            l--;
            }
        }
    else
        {
        char *p;
        int t;

        l = strlen( rb ) - 4;

        for( j=0, p=&rb[4]; p < (&rb[4]+l); p+=5 )
            {
            de[ i++ ] = ((p[0]&0x1f)<<3) | ((p[1]&0x1C)>>2);
            de[ i++ ] = ((p[1]&0x03)<<6) | ((p[2]&0x1F)<<1)|((p[3]&0x10)>>4);
            de[ i++ ] = ((p[3]&0x0f)<<4) | ((p[4]&0x1E)>>1);
            for( t=0,k=0; k<5; k++ ) t=t*3+((p[k]&0x60)>>5)-1;
            de[ i++ ] = ((p[4]&1)<<7) | t;
            j+=4;
            };
        }
	}
	else
	{
	memset( de, 0, sizeof(de) );
	memcpy( de, rb+4, stlrb );
	}


	if ( bits8 )
		{
		l = dbin8( stlrb-4, de, rb );
        memcpy( de, rb, l );
		}
	else
    if ( compress && version < 5 ) /* old method with possible bug's (crash) */
        {
        l = cdecode( l, de, rb );
        memcpy( de, rb, l );
        }

	if ( version >= 5 )
		{
		l = drep( l, de, rb );
        memcpy( de, rb, l );
		}

#ifdef DEBUG_TIMING
	ticks2 = get_ticks();
	ttime = (ticks2 < ticks1) ? (0xFFFF - ticks1) + ticks2 : ticks2 - ticks1;

	fprintf( stderr, "\ncompute decode() %04x %04x %d\n", ticks1,ticks2,ttime );
	fprintf( stderr, "Time: %u.%02u seconds\n", ttime / 20, 5 * (ttime % 20));
#endif

    return ( s );
}

/*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*/

int ebin8( len, in, out )
int len;
unsigned char *in;
unsigned char *out;
{
	register int i, j;

	/* l'octet le moins utilise dans le paquet */
	char mu = lemoinsutilise( in, len );

	/* Elimination des 0x00, 0x0a, 0x0d, 'mu' dans
       le paquet de donnees a encode en 8 bits */

	for( i=0, j=1, out[0]=mu; i<len; i++,j++ )
		{
		switch( in[i] )
			{
			case 0x00:	out[ j++ ] = mu;	out[ j ] = '0';		break;
			case 0x0a:	out[ j++ ] = mu;	out[ j ] = 'a'; 	break;
			case 0x0d: 	out[ j++ ] = mu;	out[ j ] = 'd'; 	break;
			default:
						if ( in[i] == mu )
							{
							out[ j++ ] = mu;
							out[ j ] = '4';
							}
						else
							out[ j ] = in[ i ];
						break;
			}
		}

	/* Retourne la lng du paquet encode */
	return( j );
}

/*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*/

int dbin8( len, in, out )
int len;
unsigned char *in;
unsigned char *out;
{
	register int i, j;
	
	for( i=1, j=0; i<len; i++,j++ )
		{
		if ( in[i] == in[0] )
			{
			i++;
			switch( in[i] )
				{
				case '0': out[j] = 0x00;  break;
				case 'a': out[j] = 0x0a;  break;
				case 'd': out[j] = 0x0d;  break;
				case '4': out[j] = in[0]; break;
				default: 
					/* should not occure */
					printf("WARNING dbin8() default\n" );
					break;
				}
			}
		else
			out[ j ] = in[ i ];
		}

	return( j );
}

/*---------------------------------------------------------------------------*/
/* erep()             Fonction d'elimination des repetitions dans un paquet  */
/*                                                                           */
/* L'octet 0 (zero) du paquet en sortie, defini que l'elimination des        */
/* repetitions a ete ou non realise. (En effet, si le paquet resultant       */
/* plus grand que l'original, il n'y a pas d'encodage)                       */
/* Dans le cas d'un paquet ou les repetitions sont code, l'octet 1, est le   */
/* code ascii (le moins utilise du paquet) qui a ete utilise pour prefixer   */
/* les repetitions. Cette octet est lui meme code, comme etant une           */
/* repetition de zero octet de longueur                                      */
/*---------------------------------------------------------------------------*/

int
erep( len, in, out )
int len;
unsigned char *in;
unsigned char *out;
{
	register int i, j;
	int rep = 0;

	/* l'octet le moins utilise dans le paquet */
	char mu = lemoinsutilise( in, len );

	/* elimination des repetitions */
	for( i=0, j=2; i<len && j != -1; i++, j++ )
		{
		if ( (in[i]==in[i+1] && in[i]==in[i+2]) || in[i]==mu )
			{
			if ( in[i] == mu )
				rep = 0;
			else
				{
				rep = 1;
				while( in[i] == in[i+rep+1] && rep < 250 ) rep++;
				}
			out [ j++ ] = mu;
			out [ j++ ] = in[i];
			out [ j   ] = rep;

			i += rep;
			}
		else
			out[ j ] = in [ i ];

		/* si la copie est plus grande que l'original, on stop tout */
		if ( j > len )
			{
			j = -1;
			break;
			}
		}

	/* si j == -1 alors le paquet apres encodage est + long que l'original */

	if ( j == -1 )
		{
		out[0] = '-'; /* paquet dans un format non comprime */
		memcpy( out+1, in, len );

		return( len+1 );
		}
	else
		{
		out[0] = 'C'; /* paquet dans un format comprime */
		out[1] = mu;  /* le caractere le moins utilise */

		return( j );
		}
}

/*---------------------------------------------------------------------------*/
/* drep()         Fonction de reconstruction des repetitions dans un paquet  */
/*                                                                           */
/* L'octet 0 (zero) du paquet en sortie, defini que l'elimination des        */
/* repetitions a ete ou non realise.                                         */
/*---------------------------------------------------------------------------*/

int
drep( len, in, out )
int len;
unsigned char *in;
unsigned char *out;
{
	register int i, j;
	unsigned char mu;

	if ( in[0] == '-' ) /* pas de reconstruction de paquet */
		{
		memcpy( out, in+1, len );
		return( len ) ;
		}

	if ( in[0] == 'C' ) /* paquet encode (repetition) */
		{
		mu = in[1];

		for( i=2, j=0; i<len; i++, j++ )
			{
			if ( in[i] == mu )
				{
				int nbrep = in[ i+2 ] + 1;
				while( nbrep-- ) out[j++] = in[ i+1 ];
				j--;
				i += 2;
				}
			else
				out[ j ] = in[ i ];
			}
		}

	return( j ) ;
}

/*---------------------------------------------------------------------------*/
/* lemoinsutilise() Retourne l'octet le moins utilise d'un paquet de donnees */
/*---------------------------------------------------------------------------*/

int lemoinsutilise( data, len )
unsigned char *data;
int len;
{
	register int i, j;

	static int pu[ 257 ];
	char mu;

	/* Recherche de l'octet le moins utilise dans le paquet */

	memset( pu, 0, sizeof(pu) );
	for( i=0; i<len; i++ ) pu[ data[i] ] ++;
	
	/* 'mu' est l'octet le moins utilise du paquet */
	mu = -1;

	/* debute a 1 et non 0, en cas d'encodage 8bits */
	for( i=0; i<256 && mu==-1; i++ )
		for( j=1; j<256 && mu==-1; j++ )
			if ( pu[j] == i ) mu = j;

	if ( mu == 0x0a || mu == 0x0d ) mu = 1;

	return( (int) mu );
}

/*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*/






/* module repris sans changement (avec les bugs) des sources de JMODEM. [jcm] */
/****************************************************************************/
/*                   Encode (compress) the input string.                    */
/*   The routine looks for groups of identical characters and replaces them */
/*   with the character  0xBB, a word denoting the number of characters to  */
/*   duplicate, followed by the character to duplicate.                     */
/*                                                                          */
/****************************************************************************/

unsigned cencode(len, in_buffer, out_buffer)
unsigned len;                             /* Length of input string   */
unsigned char *in_buffer;                       /* Pointer to input buffer  */
unsigned char *out_buffer;                      /* Pointer to output buffer */
{
    unsigned how_many=0;                  /* Character count          */
    unsigned count=0;                     /* Output byte count        */
    unsigned char dupl;                         /* Character to replace     */

    while (len)                                 /* While bytes in buffer    */
    {
        if ( (*in_buffer == 0xBB)               /* If the sentinel byte     */
          || (*in_buffer == *(in_buffer+1)) )   /* If two adjacent the same */
        {
            *out_buffer++ = 0xBB;               /* Insert , bump pointer    */
            dupl = *in_buffer;                  /* Save duplicate character */
            how_many = 0;                       /* Duplicate char count     */
            while ( (*in_buffer++ == dupl)      /* Count duplicates         */
                  && (len) )        /* While bytes still left.  */
            {
                how_many++;                     /* Identical characters     */
                len--;
            }

            *out_buffer++ =
               (unsigned char) how_many;       /* Character count, low byte */
            *out_buffer++ =
              (unsigned char) (how_many >> 8); /* Character count high byte */
            *out_buffer++ = dupl;              /* The duplicate character   */
            count += 4;                        /* Adjust byte count         */
            in_buffer--;                       /* Non-duplicate character   */
        }
        else
        {
        *out_buffer++ = *in_buffer++;      /* Copy byte                 */
        count++;                           /* Character count           */
            len--;
        }
#ifdef UNUSED 
    if ( count > DAT_MAX )                 /* Check buffer limit        */
            return JM_MAX;
#endif
    }
    return count;                              /* New length                */
}

/****************************************************************************/
/*                     Decode (expand) the encoded string.                  */
/*    Routine checks for a sentinel byte, 0xBB, and if found, takes the     */
/*    following word as the number of identical bytes to add. The actual    */
/*    byte to add is located following the length-word.                     */
/*                                                                          */
/****************************************************************************/

unsigned cdecode(len, in_buffer, out_buffer)
unsigned len;                             /* Length to input string   */
unsigned char *in_buffer;                       /* Pointer to input buffer  */
unsigned char *out_buffer;                      /* Pointer to output buffer */
{
    unsigned i=0;
    unsigned j=0;
    unsigned char c;
    unsigned char *limit;                       /* Length of input buffer   */

    limit = in_buffer + len;                    /* Set end pointer once     */
    while (in_buffer < limit)
    {
        if (*in_buffer == 0xBB )                /* If the sentinel byte     */
        {
             in_buffer ++;                      /* Next character           */
             i = (unsigned short) *in_buffer++; /* Get low byte, incr       */
             i = i | (unsigned short)
                 *in_buffer++ << 8;             /* Get high byte, incr      */
             c = *in_buffer++;                  /* Get byte, incr           */
             for ( ; i >0; i--)                 /* Don't alter i at start   */
             {
                 *out_buffer++ = c;             /* Expand byte              */
                 j++;                           /* Character count          */
             }
        }
        else                                    /* Else, just copy          */
        {
            *out_buffer++ = *in_buffer++;
            j++;                                /* Character count          */
        }
    }
    return j;                                   /* New string length        */
}
